// DirectIODlg.cpp : implementation file
//

#include "stdafx.h"
#include "DirectIO.h"
#include "DirectIODlg.h"
#include "DlgProxy.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirectIODlg dialog

IMPLEMENT_DYNAMIC(CDirectIODlg, CDialog);

CDirectIODlg::CDirectIODlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDirectIODlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDirectIODlg)
	m_bit0 = FALSE;
	m_bit1 = FALSE;
	m_bit2 = FALSE;
	m_bit3 = FALSE;
	m_bit4 = FALSE;
	m_bit5 = FALSE;
	m_bit6 = FALSE;
	m_bit7 = FALSE;
	m_inputs = 0;
	m_relay1 = FALSE;
	m_relay2 = FALSE;
	m_relay3 = FALSE;
	m_relay4 = FALSE;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pAutoProxy = NULL;
}

CDirectIODlg::~CDirectIODlg()
{
	// If there is an automation proxy for this dialog, set
	//  its back pointer to this dialog to NULL, so it knows
	//  the dialog has been deleted.
	if (m_pAutoProxy != NULL)
		m_pAutoProxy->m_pDialog = NULL;
}

void CDirectIODlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDirectIODlg)
	DDX_Check(pDX, IDC_CHECK1, m_bit0);
	DDX_Check(pDX, IDC_CHECK2, m_bit1);
	DDX_Check(pDX, IDC_CHECK3, m_bit2);
	DDX_Check(pDX, IDC_CHECK4, m_bit3);
	DDX_Check(pDX, IDC_CHECK5, m_bit4);
	DDX_Check(pDX, IDC_CHECK6, m_bit5);
	DDX_Check(pDX, IDC_CHECK7, m_bit6);
	DDX_Check(pDX, IDC_CHECK8, m_bit7);
	DDX_Text(pDX, IDC_INPUTS, m_inputs);
	DDX_Check(pDX, IDC_K1, m_relay1);
	DDX_Check(pDX, IDC_K2, m_relay2);
	DDX_Check(pDX, IDC_K3, m_relay3);
	DDX_Check(pDX, IDC_K4, m_relay4);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDirectIODlg, CDialog)
	//{{AFX_MSG_MAP(CDirectIODlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_CLOSE()
	ON_WM_CREATE()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_CHECK1, OnCheck)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_K1, OnINPUT)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck)
	ON_BN_CLICKED(IDC_CHECK4, OnCheck)
	ON_BN_CLICKED(IDC_CHECK5, OnCheck)
	ON_BN_CLICKED(IDC_CHECK6, OnCheck)
	ON_BN_CLICKED(IDC_CHECK7, OnCheck)
	ON_BN_CLICKED(IDC_CHECK8, OnCheck)
	ON_BN_CLICKED(IDC_K3, OnINPUT)
	ON_BN_CLICKED(IDC_K4, OnINPUT)
	ON_BN_CLICKED(IDC_K2, OnINPUT)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDirectIODlg message handlers

BOOL CDirectIODlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	this->m_pdio->OpenDevice(0);
// write to offset of 3 the Control Register to configure
// Port B as an output.  This is necessary for control of 
// output relays on an SRA-01
	
// Control register follows logic of mode 0 of Intel 8255
// write a 0 for Output;  write a 1 for Input
// bit 0 = Port C, lower 4 bits, 1 = input, 0 =  output
// bit 1 = Port B, 1 = input, 0 = output
// bit 2 = not used, always 0
// bit 3 = Port C, upper 4 bits
// bit 4 = Port A
// bits 5,6,7 = not used, always 0

	this->m_pdio->Write(3,0x19);  // configure B as output; others inputs

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDirectIODlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDirectIODlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDirectIODlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

// Automation servers should not exit when a user closes the UI
//  if a controller still holds on to one of its objects.  These
//  message handlers make sure that if the proxy is still in use,
//  then the UI is hidden but the dialog remains around if it
//  is dismissed.

void CDirectIODlg::OnClose() 
{
	if (CanExit())
		CDialog::OnClose();
}

void CDirectIODlg::OnOK() 
{
	if (CanExit())
		CDialog::OnOK();
}

void CDirectIODlg::OnCancel() 
{
	if (CanExit())
		CDialog::OnCancel();
}

BOOL CDirectIODlg::CanExit()
{
	// If the proxy object is still around, then the automation
	//  controller is still holding on to this application.  Leave
	//  the dialog around, but hide its UI.
	if (m_pAutoProxy != NULL)
	{
		ShowWindow(SW_HIDE);
		return FALSE;
	}

	return TRUE;
}



int CDirectIODlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

int result;

try 
	{
		// The following smart pointer declaration will create
		// an instance of the object.
        KPCIDIOLib::IKPCIPIOPtr pio( __uuidof(KPCIDIOLib::KPCIPIO) );
		this->m_pdio = pio;
		result = 0;
	}
	catch (const _com_error& Err) 
	{
		TRACE( "Error in Creation of KPCIPIO object:\nError number is 0x%08X\nError message is %s\n", Err.Error( ), Err.ErrorMessage( ) );
		// Display error description if rich error info supported
		if ( Err.ErrorInfo( ) )
			TRACE( "%s\n\n", Err.Description( ) );

		result = -1;
	}
	return result;
}

void CDirectIODlg::OnDestroy() 
{
	CDialog::OnDestroy();
	// stop the timer and close the driver
	KillTimer(IDC_TIMER);
	this->m_pdio->Write(1,0);  // write zero to Port B to turn off all relays on exit
	this->m_pdio->CloseDevice();
	
}


void CDirectIODlg::OnCheck() 
{
	// use this overloaded function to update the Relays
	// when one of the check boxes is clicked.
    int doValue;

    UpdateData(TRUE); // update from the Dialog
	doValue = 1 * m_bit0 + 2*m_bit1 + 4*m_bit2;
    doValue = doValue + 8*m_bit3 + 16*m_bit4; 
	doValue = doValue + 32*m_bit5 + 64*m_bit6 + 128*m_bit7; 

	this->m_pdio->Write(1,doValue);  // write to Port B
}


void CDirectIODlg::OnTimer(UINT nIDEvent) 
{
	// poll the state of the inputs
	switch (nIDEvent)
	case IDC_TIMER:
	{
       m_inputs = this->m_pdio->Read(0x2);  // read port C
	   m_inputs = m_inputs & 0xF;  // mask off the upper nibble
	   UpdateData(FALSE);  // display the value on our dialog
	}
	
	CDialog::OnTimer(nIDEvent);
}

void CDirectIODlg::OnINPUT() 
{
	// if any of the relays are inputs, then start the timer
	// so the value can be polled
	UpdateData(TRUE);  // read in current state of all dialog controls
    	// start our timer:
	SetTimer(IDC_TIMER,1000,NULL);  // a 1 second interval
	
	// should also disable the corresponding output check box
	// if the relay is now an input.....
	if (m_relay1 != 0)
	{
    GetDlgItem(IDC_CHECK8)->EnableWindow(FALSE); // disable it
	m_bit7 = 0;   // set it's value to off
	}else
	{
      GetDlgItem(IDC_CHECK8)->EnableWindow(TRUE);  // enable it
	}
   
    if (m_relay2 != 0)
	{
    GetDlgItem(IDC_CHECK7)->EnableWindow(FALSE);
	m_bit6 = 0;
	}else
	{
      GetDlgItem(IDC_CHECK7)->EnableWindow(TRUE);
	}

    if (m_relay3 != 0)
	{
    GetDlgItem(IDC_CHECK6)->EnableWindow(FALSE);
	m_bit5 = 0;
	}else
	{
      GetDlgItem(IDC_CHECK6)->EnableWindow(TRUE);
	}

    if (m_relay4 != 0)
	{
    GetDlgItem(IDC_CHECK5)->EnableWindow(FALSE);
	m_bit4 = 0;
	}else
	{
      GetDlgItem(IDC_CHECK5)->EnableWindow(TRUE);
	}

	
	UpdateData(FALSE);  // update the dialog
}

/*
    This example was written with KPCI-PIO24 and SRA-01
	using kpcipio-850A04 version of DriverLINX in Win2K SP1.

    It uses the Direct I/O COM API of DriverLINX to program the 
	KCPI-PIO24 board.

    It interfaces with the 8 main relays on the SRA-01.  The 9th
	relay interfaces to the external IRQ feature of the KPCI-PIO24
	or PIO-24.  Use of the Service Request API of DriverLINX is required
	to process interrupts from the board;  see any of the other examples
	for use of external IRQ feature of KPCI-PIO24 for an example suitable
	for relay K9.

    Relay positions K1 to K4 can be populated with input or output relays.
	
    Any of them that are inputs will feed their logic 1 or 0 state into
	the four lower bits of Port C (K1 = bit3, K3 = bit0).  A logic 1
	corresponds to an OFF condition;  a logic 0 corresponds to an ON condition.

    Any of the 8 relay positions that can host output relays is controlled by
	Port B of the KPCI-PIO24.  Bit 0 of Port B corresponds to relay position K8,
	and so on.

*/
